#include "game.h"

void IWRAM_CODE RemoveExplosionParticle(int n)
{
	active_explosionparticles--;
	if(n==active_explosionparticles) return;

	sExplosionParticle* src = &exp_particle[active_explosionparticles];
	sExplosionParticle* dst = &exp_particle[n];

	dst->x = src->x;
	dst->y = src->y;
	dst->xinc = src->xinc;
	dst->yinc = src->yinc;
	dst->strength = src->strength;
}

void IWRAM_CODE CreateRandomExplosionParticle(int x, int y)
{
	if(active_explosionparticles==MAX_EXPLOSIONPARTICLES) return;
	sExplosionParticle* p = &exp_particle[active_explosionparticles++];

	int a = rand();

	p->x = x<<8;
	p->y = y<<8;
	p->strength = 16;
	p->xinc = GetCos(a);
	p->yinc = GetSin(a);
}

void IWRAM_CODE ParticlesUpdate(void)
{
	int i;
	for(i=0;i<active_explosionparticles;i++)
	{
		sExplosionParticle* p = &exp_particle[i];

		p->x += p->xinc * p->strength >> 2;
		p->y += p->yinc * p->strength >> 2;
		p->strength--;
		if(!p->strength || p->x < 0 || p->x > 239<<8 || p->y < 0 || p->y > 159<<8) RemoveExplosionParticle(i--);
		else DrawPixelToBuffer(p->x>>8,p->y>>8,p->strength+16,BackBuffer);
	}
}
